Ext.data.JsonP.sol_common_monitoring_as_analyzers_RuleAnalyzer({"tagname":"class","name":"sol.common_monitoring.as.analyzers.RuleAnalyzer","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.js","href":"lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer"}],"eloas":true,"requires":["sol.common.DateUtils","sol.common.JsonUtils","sol.common.SordUtils","sol.common_monitoring.as.MonitorUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"rules","tagname":"cfg","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"cfg-rules","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"analyze","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"method-analyze","meta":{}},{"name":"analyzeRule","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"method-analyzeRule","meta":{"private":true}},{"name":"checkExecution","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"method-checkExecution","meta":{"private":true}},{"name":"countHits","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"method-countHits","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"sanitizeIsoDate","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"method-sanitizeIsoDate","meta":{"private":true}},{"name":"shiftIso","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"method-shiftIso","meta":{"private":true}},{"name":"updateExecution","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RuleAnalyzer","id":"method-updateExecution","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common_monitoring.as.analyzers.RuleAnalyzer","short_doc":"Analyzes if a set of rules is applicable for an object. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common_monitoring.as.analyzers.RuleAnalyzer</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common_monitoring.as.MonitorUtils' rel='sol.common_monitoring.as.MonitorUtils' class='docClass'>sol.common_monitoring.as.MonitorUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer' target='_blank'>lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.js</a></div></pre><div class='doc-contents'><p>Analyzes if a set of rules is applicable for an object.</p>\n\n<p>A rule should at least contain an <code>action</code>, which should be executed later if the rule applies to the analyzed object,\nand a <code>date</code> configuration (see <a href=\"#!/api/sol.common.SordUtils-method-getValue\" rel=\"sol.common.SordUtils-method-getValue\" class=\"docClass\">sol.common.SordUtils.getValue</a>) on which all checks will be performed.</p>\n\n<p>Additionally it can specify a <code>shift</code> and a <code>recur</code> attribute (for poosible configurations see <a href=\"#!/api/sol.common_monitoring.as.MonitorUtils-method-evalDateUnitConfig\" rel=\"sol.common_monitoring.as.MonitorUtils-method-evalDateUnitConfig\" class=\"docClass\">MonitorUtils</a>).\nWhile <code>shift</code> can be a positive or a negative value, <code>recure</code> has to be positive.\nAlso optional is the <code>execution</code> attribute, which saves the last execution eiter to a map field or an index field. In case the rule is 'reoccuring' it is mandatory,\nbecause the analyzer needs determine when the next reoccurrence should be.</p>\n\n<p><code>date</code> only: the analyzer just checks, if the date is in the past</p>\n\n<p><code>shift</code>: the analyzer checks, if the date plus/minus a value is already exceeded.</p>\n\n<p><code>recur</code>: the analyzer checks, if the date (or the last execution) plus a value is exceeded.</p>\n\n<p><code>shift</code> and <code>recur</code> can be combined.</p>\n\n<p>If <code>date</code> or <code>shift</code> rules hit, now next run will be calculated, if they miss, the analyzer determines the date for the next check.\n<code>recur</code> rules always calculate a next run date (no breaking condition so far).</p>\n\n<p>Each kind of rule returns it's specified action when it hits.</p>\n\n<pre><code>var analyzer = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer\" rel=\"sol.common_monitoring.as.analyzers.RuleAnalyzer\" class=\"docClass\">sol.common_monitoring.as.analyzers.RuleAnalyzer</a>\", {\n  rules: [\n    ... rule objects ...\n  ]\n});\n</code></pre>\n\n<h1>Example rules:</h1>\n\n<p>Starts a workflow (in the context of the user \"John Doe\"), if the date in the MY_DATE field is in the past:</p>\n\n<pre><code>{\n  action: { type: \"WORKFLOW\", templateId: \"MyWorkflowTemplate\", user: \"John Doe\" },\n  date: { type: \"GRP\", key: \"MY_DATE\" },\n}\n</code></pre>\n\n<p>If you don't want to filter by date, instead of defining <code>date</code>, you can define <code>noAdditionalDateCheck: true</code>. This will execute the action for every sord found by the collector.</p>\n\n<p>Creates a reminder if the date in the MY_DATE field is less then two months in the future (date minus 2 month is before now) and saves the current date to a map field:</p>\n\n<pre><code>{\n  action: { type: \"REMINDER\", user: \"Administrator\" },\n  date: { type: \"GRP\", key: \"MY_DATE\" },\n  shift: { value: -2, unit: \"M\" },\n  execution: { type: \"MAP\", key: \"MY_DATE_EXECUTION\" }\n}\n</code></pre>\n\n<p>Starts a workflow, if the date from the map field (see execution - or if not already set, the <code>date</code> itself) plus the value from the MY_REOCCURRENCE field in days (\"D\") is in the past,\nand saves the date of the last sheduled execution a map field (therefor all recurring events will be executed, even if several checks have been missed).</p>\n\n<pre><code>{\n  action: { type: \"WORKFLOW\", templateId: \"MyWorkflowTemplate\" },\n  date: { type: \"GRP\", key: \"MY_DATE\" },\n  recur: { type: \"GRP\", key: \"MY_REOCCURRENCE\", unit: \"D\" },\n  execution: { type: \"MAP\", key: \"MY_DATE_EXECUTION\" }\n}\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;rules&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-rules' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-cfg-rules' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-cfg-rules' class='name expandable'>rules</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-analyze' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-method-analyze' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-method-analyze' class='name expandable'>analyze</a>( <span class='pre'>sord</span> ) : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Analyzes an object utilizing the set of rules set during initialization. ...</div><div class='long'><p>Analyzes an object utilizing the set of rules set during initialization.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-analyzeRule' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-method-analyzeRule' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-method-analyzeRule' class='name expandable'>analyzeRule</a>( <span class='pre'>sord, rule</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Analyze an individual rule. ...</div><div class='long'><p>Analyze an individual rule.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>rule</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkExecution' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-method-checkExecution' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-method-checkExecution' class='name expandable'>checkExecution</a>( <span class='pre'>sord, execution</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the value of an earlier execution depending on a given configuration. ...</div><div class='long'><p>Retrieves the value of an earlier execution depending on a given configuration.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>execution</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-countHits' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-method-countHits' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-method-countHits' class='name expandable'>countHits</a>( <span class='pre'>results</span> ) : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Counts the results, that where a hit. ...</div><div class='long'><p>Counts the results, that where a hit. A hit is marked by a result, containing an action.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>results</span> : Object[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-sanitizeIsoDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-method-sanitizeIsoDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-method-sanitizeIsoDate' class='name expandable'>sanitizeIsoDate</a>( <span class='pre'>isoDate, verificationDate</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Fills isoDate to the correct amount of digigt to prevent the fail of a check. ...</div><div class='long'><p>Fills isoDate to the correct amount of digigt to prevent the fail of a check.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isoDate</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>verificationDate</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-shiftIso' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-method-shiftIso' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-method-shiftIso' class='name expandable'>shiftIso</a>( <span class='pre'>sord, isoDate, params</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Shifts an ISO date. ...</div><div class='long'><p>Shifts an ISO date. Uses <a href=\"#!/api/sol.common.DateUtils\" rel=\"sol.common.DateUtils\" class=\"docClass\">DateUtils</a> and <a href=\"#!/api/sol.common_monitoring.as.MonitorUtils\" rel=\"sol.common_monitoring.as.MonitorUtils\" class=\"docClass\">MonitorUtils</a> internally</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>isoDate</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>See <a href=\"#!/api/sol.common_monitoring.as.MonitorUtils-method-evalDateUnitConfig\" rel=\"sol.common_monitoring.as.MonitorUtils-method-evalDateUnitConfig\" class=\"docClass\">evalDateUnitConfig</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-updateExecution' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RuleAnalyzer'>sol.common_monitoring.as.analyzers.RuleAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RuleAnalyzer.html#sol-common_monitoring-as-analyzers-RuleAnalyzer-method-updateExecution' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RuleAnalyzer-method-updateExecution' class='name expandable'>updateExecution</a>( <span class='pre'>sord, execution, date</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Updates the value of the current execution depending on a given configuration. ...</div><div class='long'><p>Updates the value of the current execution depending on a given configuration.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>execution</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>date</span> : String<div class='sub-desc'><p>An ISO date to set according to <code>execution</code></p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true}});